;___________________________________________

; 	TextPad Syntax Generator Script
;               -Rajat
;___________________________________________

SetBatchLines, -1     ; Speeds up file operations.
SetWorkingDir, ..\..  ; Set it to the Editors folder.

TargetFile = TextPad\AutoHotkey.syn
FileDelete, %TargetFile%

FileAppend, `; TextPad keyword syntax file for AutoHotkey`n, %TargetFile%
FileAppend, `; Auto generated by Rajat's TextPad Syntax Generator Script`n`n, %TargetFile%

FileAppend, C=1`n`n, %TargetFile%

FileAppend, [Syntax]`n, %TargetFile%
FileAppend, Namespace1 =`n, %TargetFile%
FileAppend, IgnoreCase = Yes`n, %TargetFile%
FileAppend, `;BracketChars = {}`n, %TargetFile%
FileAppend, OperatorChars = +-*/<>=`n, %TargetFile%
FileAppend, PreprocStart =`n, %TargetFile%
FileAppend, SyntaxStart =`n, %TargetFile%
FileAppend, SyntaxEnd =`n, %TargetFile%
FileAppend, CommentStart = /*`n, %TargetFile%
FileAppend, CommentEnd = */`n, %TargetFile%
FileAppend, CommentStartAlt =`n, %TargetFile%
FileAppend, CommentEndAlt =`n, %TargetFile%
FileAppend, SingleComment = `;`n, %TargetFile%

; Not desirable because it prevents comments on the same line as a command from being highlighted as a comment:
;FileAppend, SingleCommentCol = Leading`n, %TargetFile%

FileAppend, SingleCommentEsc = ```n, %TargetFile%
FileAppend, StringsSpanLines = No`n, %TargetFile%
FileAppend, StringStart = `%`n, %TargetFile%
FileAppend, StringEnd = `%`n, %TargetFile%
FileAppend, StringAlt = "`n, %TargetFile%
FileAppend, StringEsc = ```n, %TargetFile%
FileAppend, CharStart =`n, %TargetFile%
FileAppend, CharEnd =`n, %TargetFile%
FileAppend, CharEsc = ```n, %TargetFile%
FileAppend, `n, %TargetFile%

FileAppend, [Keywords 1]`n, %TargetFile%


;this doesn't require fancy cmd names for human reading,
;it just requires names to be highlighted. so getting first name only

Loop, Read, Syntax\Commands.txt, %TargetFile%
{
	CurrCmd =
	FullCmd = %a_loopreadline%
	
	;directives don't have first comma but a first space
	;so whichever is first, take it as end of cmd name
	StringGetPos, cPos, a_loopreadline, `,
	StringGetPos, sPos, a_loopreadline, %A_Space%
	
	IfLess, sPos, %cPos%
		IfGreater, sPos, 0
			StringLeft, CurrCmd, a_loopreadline, %sPos%
	
	IfLess, cPos, %sPos%
		IfGreater, cPos, 0
			StringLeft, CurrCmd, a_loopreadline, %cPos%

	IfLess, cPos, %sPos%
		IfLess, cPos, 0
			StringLeft, CurrCmd, a_loopreadline, %sPos%

	IfLess, sPos, %cPos%
		IfLess, sPos, 0
			StringLeft, CurrCmd, a_loopreadline, %cPos%
			
	StringReplace, FullCmd, FullCmd, ``n, `n, a
	StringReplace, FullCmd, FullCmd, ``t, `t, a

	StringReplace, CurrCmd, CurrCmd, [,, a
	StringReplace, CurrCmd, CurrCmd, %a_space%,, a
	
	;For a directive that has no parameters
	IfEqual, CurrCmd,
		CurrCmd = %a_loopreadline%
	
	
	;this check removes duplicates for loop and if
	IfNotEqual, CurrCmd, %LastCmd%
		FileAppend, %CurrCmd%`n
	
	LastCmd = %CurrCmd%
}


FileAppend, `n[Keywords 2]`n, %TargetFile%

;Adding keywords including the blank lines and comments
Loop, Read, Syntax\Keywords.txt, %TargetFile%
	FileAppend, %A_LoopReadLine%`n

FileAppend, `n`n, %TargetFile%

;same with variables
Loop, Read, Syntax\Variables.txt, %TargetFile%
	FileAppend, %A_LoopReadLine%`n



FileAppend, `n[Keywords 3]`n, %TargetFile%

;keys are added with and without {}
Loop, Read, Syntax\Keys.txt, %TargetFile%
{
	FileAppend, %A_LoopReadLine%`n
	IfEqual, A_LoopReadLine,, Continue
	
	;comment check
	StringReplace, check, A_LoopReadLine, %A_Space%,, A
	StringReplace, check, check, %A_Tab%,, A
	StringLeft, check, check, 1
	IfEqual, check, `;, Continue
	
	FileAppend, {%A_LoopReadLine%}`n
}
	


;Now generating the ClipLibrary
TargetFile = TextPad\AutoHotkey.tcl

FileDelete, %TargetFile%

FileAppend, !TCL=3468`, Auto-generated by Rajat's TextPad Syntax Generator Script`n, %TargetFile%
FileAppend, !TITLE=AutoHotkey`n, %TargetFile%
FileAppend, !SORT=Y`n, %TargetFile%



;adding commands
Loop, Read, Syntax\Commands.txt, %TargetFile%
{
	FileReadLine, CmdName, Syntax\CommandNames.txt, %A_Index%
	StringReplace, FullCmd, A_LoopReadLine, ``n, `n, a
	StringReplace, FullCmd, FullCmd, ``t, %A_Tab%, a
	
	FileAppend, !TEXT=%CmdName%`n%FullCmd%`n!`n
}

;adding variables
Loop, Read, Syntax\Variables.txt, %TargetFile%
	FileAppend, !TEXT=%A_LoopReadLine%`n%A_LoopReadLine%`n!`n
